// globals
d2r = Math.PI/180;
r2d = 180/Math.PI;
var insig = 0;
var zn = "AriTauGemCanLeoVirLibScoSagCapAquPis";  // Zodiac
var range = [1,31,1,12,1800,2100,0,23,0,59,0,12,0,59]; 	
// var naks = ["Aswini","Bharani","Krittika","Rohini","Mrigsira","Ardra","Punarvasu",
// "Pushya","Aslesha","Magha","P.Phalguni","U.Phalguni","Hasta","Chitra","Swati","Vishakha",
// "Anuradha","Jyeshtha","Mula","P.Shadya","U.Shadya","Shravana","Dhanishtha",
// "Shatbisha","P.Phadra","U.Phadra","Revati"];
var znak = ["","","","",
"","","","","","","",""];
var naksw = ["",
"",
"",
"",
"",
"",
"",
" ",
"",
"",
"",
"",
"",
"",
"",
" ",
"",
"",
"",
" ",
"",
"",
"",
"",
"",
"",
""];
var nakst = [" -  , - , 3",
" - 41 ,  , 4",
" -  ,  , 3",
" -  ,  , 1",
" -  ,  , 3",
" -  ,  , 0",
" -  ,  , 1",
"  -  P,  , 4",
" -  ,  , 2",
" -  ,  , 1",
" -  , - , 3",
" -  , - , 2",
" -  ,  , 3",
" -  ,  , 1",
" -  ,  , 0",
"  -  , - , 3",
" -  ,  , 2",
" -  ,  , 1",
" -  ,  , 2",
"  -  ,  , 3",
" -  ,  , 2",
" -  , - , 1",
" -  ,  , 4",
" -  ,  , 4",
" -  ,  , 2",
" -  ,  , 3",
" -  ,  , 6"];
var naks = [" (Ashwini)",
" (Bharani)",
" (Krittika)",
" (Rohini)",
" (Mrigashira)",
" (Ardra)",
" (Punarvasu)",
" (Pushya)",
" (Ashlesha)",
" (Makha)",
" (Purvaphalguni)",
" (Uttaraphalguni)",
" (Hasta)",
" (Chitra)",
" (Swati)",
" (Vishakha)",
" (Anuradha)",
" (Jyeshtha)",
" (Mula)",
" (Purvashadha)",
" (Uttarashadha)",
" (Shravana)",
" (Dhanishtha)",
" (Satabhisha)",
" (Purvabhadrapada)",
" (Uttarabhadrapada)",
" (Revati)"];

var stx = new Array (27);
stx[0] = " -  ,  ,    .  ''    ,  .    ,    ,  ,      .       -   ,   , .   , ,  ,     .  , ,  ,    .";
stx[1] = " - ,  '', ''   .    - , .    , ,     , ,   -.       .   ,  ,    ,    .   -   ,    .    ,     , ,   .";
stx[2] = " -  ,   ,     . ''  ''.   ,  ,    .   ,  ,        , .  -  - ;     .      ,   ,   .          .     ,    .";
stx[3] = " -  ,  ,    .  - ,  ''     ,   ,   .     ,   ,    ,   .    ,      ,     ,   .     .  , ,   , ,  ,  .";
stx[4] = "'' -  ''.       ,   .  ,  , '' -    ,    ,  . ''    ' '.    ,    ,  .    ,   ,  .  ,   , , ,  ,   ,    , ,    .      ,   , .";
stx[5] = " -  '', ''  .       '',    ,    .   -   ,  ,    -   ,  .     ,  .      ,   ,   ,    ,        .     , , ,    , .";
stx[6] = "''  ''.    ' '.   ,    ,  ,         ,   .  - '',  ,    - .   ,    .  -   . ''   '',  ''.     , , ,  ,    ,      .";
stx[7] = "    .  - ''     ,   .     ,      ,    , . ,    ,      .     ,     .    ,   .    ,  ,  , , ,  .";
stx[8] = " - ,    ;   -  .       ,     ,          ,  .      '';      ,  ,    .     ,       .   ,      , , , .";
stx[9] = "''   ''.   ,  ,  .  ,  ,    , , -,   ,    .      .   ,  ,    ,     .   ,  ,   ,    .      ,     ,   ,      ,      .      ,   ,  -  ,  .";
stx[10] = " - ''   ,    ,      ,    ,     ,     .   ,     .      - '  '.         ,    ''.      ,       ,  ,    .";
stx[11] = " '', '' ,      ' '.   ,    .  ,     -   -  .      ' ',     ,   .   ,     ,    ,    . ,        .        ,  , ,     ,     .";
stx[12] = "  -  .    ,  ,   ,   , .  '' - ,   .     ,  , .  -  ,  ,  .     .    , , ,        .";
stx[13] = " - ,   ,     '',  ''.     - ,  .    ,     .      ,   .  - ,     .      ,   ,   .";
stx[14] = " - '',  ;   '',   ''.      ,    ,    .     '',         ,    .    - ,  .   ,   ,   ,  , .";
stx[15] = " - ,   ,  , , ,      .     ' ',    ,   .     ,   ,    ,   ,  ,   -,    .   ,  ,   ,  ,   .";
stx[16] = " - '',  ,   .     ,  ',     ',  ,  ,    ,   .   - ' ' -   .       ' ',     .  -    ,      .    ,    ,      ,  , ,    ,  ,      ,   ,      ,      ,    .";
stx[17] = " - ,   , ,    .   ', ',  ' ';    ,    , ,    .     ,   .      ,  ,      ,    , .    , ,     .";
stx[18] = "''  '',    ,   ,    ,      .  ,   ,   ,       . ,    , , ,    ,    .   ,  ,  ,    ,  .";
stx[19] = " -  , ''   .   ,   .     '',  '',    ,  ,   ,     ,   ,     ,   ,     .    ,  ,     .    ,      ,    ,       .";
stx[20] = " - , '' ,      .        .     '',     ,    ,    ,     .    ,  -,    -    .   ,   ,   .";
stx[21] = " - '',    ,    ''.   ,        .     ,        .   ,  ,    .   , , ,    .      .";
stx[22] = " - ,   ,   ,   ,        .     '',          -  .  -  ,       .     ,          .      ,     -,  ,  ,  .";
stx[23] = " - ,   ,  ,   .   ,  ' ', ,  ,     .     .     ',  ',     ,  ,   ,       .   ,    ,     -,    .";
stx[24] = " - '',    .     ' '.     , ,   .    ,  ,   ,      .    ,  .    ,  ,  ,    '  ',     .";
stx[25] = " - ,   ''  ,     ' '.       ,          .   , ,      ,  .    ,  , ,     ,  ,   .";
stx[26] = "''   ''.  '',  ,   ,    .       ,  -  ,    .  -    ;     .   , ,    ,  , .";


// Fill out the form with current date and time
function fillDate()
{
today = new Date();
document.LunarCalc.Month.value = today.getMonth()+1;
document.LunarCalc.Day.value = today.getDate();
document.LunarCalc.Year.value = today.getFullYear();
document.LunarCalc.Hour.value = today.getHours();
document.LunarCalc.Min.value = today.getMinutes();
zmins = today.getTimezoneOffset();
with(Math){
	zmins /= 60;
	if(zmins >= 0.0)
    {
		var eln = document.LunarCalc.West;
		eln.checked = true;
		}
	zmins = abs(zmins);
	document.LunarCalc.ZHour.value = floor(zmins);
	document.LunarCalc.ZMin.value = (zmins - floor(zmins)) * 60;
	}	
}

function checkEntries(f)
{
	for(i = 0; i < 7; i++)
   {
		var e = f.elements[i];
		if((e.name == "DST") || (e.name == "West")) continue;
		if(isNaN(e.value) || (e.value < range[i*2] ) || (e.value > range[i*2+1]))
     {
			msg = "      " 
				+ range[i*2] + "   " + range[i*2+1] 
				+ "   <" + e.name + ">";
			alert(msg);
			return true;
		 }
	}
	return false;
}

function calculate()
{
if(checkEntries(document.LunarCalc)) return;

with(Math){
	var mon = floor(document.LunarCalc.Month.value);
	var day = floor(document.LunarCalc.Day.value);
	var year= floor(document.LunarCalc.Year.value);
	var hr= floor(document.LunarCalc.Hour.value);
	hr	+= floor(document.LunarCalc.Min.value)/60;
	var tz= floor(document.LunarCalc.ZHour.value);
	tz += floor(document.LunarCalc.ZMin.value)/60;
	}
// checks for checked DST, East, South
var dst = document.LunarCalc.DST;
var eln = document.LunarCalc.West;

if(dst.checked){
	if(eln.checked) tz--;
	else tz++;
	}

jd = mdy2julian(mon,day,year);
if(eln.checked) f = hr + tz;
else f = hr - tz;

//t = (jd - 2451545 - 0.5)/36525;
t = ((jd - 2451545) + f/24 - 0.5)/36525;
ay = calcayan(t);

ob = 23.452294 - 0.0130125 * t; //  Obliquity of Ecliptic
	
// Calculate Moon longitude, latitude, and distance using truncated Chapront algorithm
	
// Moon mean longitude
l = (218.3164591 + 481267.88134236 * t);
// Moon mean elongation
d = (297.8502042 + 445267.1115168 * t); 
// Sun's mean anomaly
m = (357.5291092 + 35999.0502909 * t);
// Moon's mean anomaly
mm = (134.9634114 + 477198.8676313 * t);
// Moon's argument of latitude
f = (93.2720993 + 483202.0175273 * t);

d *= d2r; m *= d2r; mm *= d2r; f *= d2r;
e = 1 - 0.002516 * t - 0.0000074 * t * t;

with(Math){ 
p =	6.288774 * sin(mm) 
	+ 1.274027 * sin(d*2-mm)
	+ 0.658314 * sin(d*2) 	
	+ 0.213618 * sin(2*mm)  
	- 0.185116 * e * sin(m) 
	- 0.114332 * sin(f*2);

p +=	  0.058793 * sin(d*2 - mm * 2)
	+ 0.057066 * e * sin(d*2 - m - mm)
	+ 0.053322 * sin(d*2 + mm)
	+ 0.045758 * e * sin(d*2 - m) 
	- 0.040923 * e * sin(m - mm) 
	- 0.034720 * sin(d)
	- 0.030383 * e * sin(m + mm);

p +=	  0.015327 * sin(d*2 - f*2)
	- 0.012528 * sin(mm + f*2)
	+ 0.010980 * sin(mm - f*2)
	+ 0.010675 * sin(d * 4 - mm)
	+ 0.010034 * sin(3 * mm);

p +=	  0.008548 * sin(d * 4 - mm * 2)
	- 0.007888 * e * sin(d * 2 + m - mm)
	- 0.006766 * e * sin(d * 2 + m)
	- 0.005163 * sin(d - mm)
	+ 0.004987 * e * sin(d + m)
	+ 0.004036 * e * sin(d*2 - m + mm)
	+ 0.003994 * sin(d * 2 + mm * 2);
	}

l += p;

while(l < 0.0) l += 360.0;
while(l > 360.0) l -= 360.0;

l += ay;
if(l < 0.0) l += 360.0;
if(l > 360.0) l -= 360.0;

nk = (l * 3)/40.0;	// get nakshatra
with(Math){ nk = floor(nk); }

document.display.notes.value = "<table border=1 width=500 align=center><tr><td align=center><font size='+2' color=red><b>   - "+naksw[nk];
document.display.notes.value += "</b></font> </td></tr><tr><td> ";
document.display.notes.value += "    : "+lon3dmsz(l)+". ";
document.display.notes.value += " : "+nakst[nk]+"-  . ";
document.display.notes.value += " : "+naks[nk]+". ";
document.display.notes.value += stx[nk];
document.display.notes.value += " </td></tr><tr><td align=center> ";
document.display.notes.value += 
"<a href='http://fevac.pisem.net/JS/yourstar.htm'>  </a>&nbsp;&nbsp;&nbsp;&nbsp; &copy;  <lj user='seasmile'>";
document.display.notes.value += " </td></tr></table>";

}


// Calculate Ayanamsa using J2000 Epoch
function calcayan(t)
{
	with(Math){
		ln = 125.0445550 - 1934.1361849 * t + 0.0020762 * t * t; // Mean lunar node
		off = 280.466449 + 36000.7698231 * t + 0.00031060 * t * t; // Mean Sun	
		off = 17.23*sin(d2r * ln)+1.27*sin(d2r * off)-(5025.64+1.11*t)*t;
		off = (off- 85886.27)/3600.0;  
	}
	return off;
}

// build string with degrees, minutes, seconds and zodiac sign from longitude
function lon2dmsz(x)
{
	with(Math){
		var d,m,s;
		x = abs(x);
		d = floor(x);
		m = (x - d);
		s = m * 60;
		m = floor(s);
		s = s - m;
		z = floor(d/30);
		d %= 30;
		str = d + " " + m + "' " + floor(s * 60) + "\" " + zn.substr(z*3,3);	
	}
	return str;
}	
function lon3dmsz(x)
{
	with(Math){
		var d,m,s;
		x = abs(x);
		d = floor(x);
		m = (x - d);
		s = m * 60;
		m = floor(s);
		s = s - m;
		z = floor(d/30);
		d %= 30;
		str = d + "" + m + "'" + floor(s * 60) + "\" " + znak[z];	
	}
	return str;
}	
// calculate Julian Day from Month, Day and Year
function mdy2julian(m,d,y)
{
	with(Math){
		im = 12 * (y + 4800) + m - 3;
		j = (2 * (im - floor(im/12) * 12) + 7 + 365 * im)/12;
		j = floor(j) + d + floor(im/48) - 32083;
		if(j > 2299171)j += floor(im/4800) - floor(im/1200) + 38;
		return j;	
	}
}
